import 'dart:convert';
import 'package:http/http.dart' as http;
import 'package:flutter/material.dart';
import '../models/custom_pages.dart';
import '/common/apipath.dart';

class CustomPagesProvider with ChangeNotifier {
  CustomPages? customPageData;

  Future<CustomPages?> fetchPages(BuildContext context) async {
    final response =
        await http.get(Uri.parse(APIData.customPages), headers: {});
    print(APIData.customPages);
    print(response.body);
    print(response.statusCode);
    if (response.statusCode == 200) {
      customPageData = CustomPages.fromJson(json.decode(response.body));
      notifyListeners();
    } else {
      throw "Can't have Page data";
    }
    notifyListeners();
    return customPageData;
  }
}
